<?php
/**
 * @version		$Id: default.php 0001 December 2011 16:31:12Z OmegaTheme $
 * @package		OT K2 Extensions
 * @author			OmegaTheme http://omegatheme.com
 * @copyright		Copyright (c) 2011 OmegaTheme.
 * @license			http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @subpackage 	OT K2 Slideshow
 */

//No direct access
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');

?>

<div class="slider-wrapper theme-default OtK2ItemsBlock" style="width: <?php echo $params->get('sliderWidth') ?>px; height: <?php echo $params->get('sliderHeight') ?>px;">
	<div id="ot-k2-slideshow" style="width: <?php echo $params->get('sliderWidth') ?>px; height: <?php echo $params->get('sliderHeight') ?>px;">
		<?php if(count($items)) : ?>
			<?php foreach($items as $key=>$item) : ?> 
			<div class="ot-item" style="width: <?php echo $params->get('sliderWidth') ?>px; height: <?php echo $params->get('sliderHeight') ?>px;">
				<?php
				//Item Image
					preg_match_all('/img src="([^"]+)"/i', $item->introtext . $item->fulltext, $matches); ?>
				<?php if(empty($matches[1][0])){ ?>
					<img style="margin: 0 auto;" src="<?php echo $params->get('image-default'); ?>" class="image-default" alt="<?php echo $item->title; ?>" title="#qitem-<?php echo $item->id; ?>" />
				<?php } else { ?>
					<img style="height: <?php echo $params->get('sliderHeight') ?>px;" src="<?php echo $matches[1][0] ; ?>" class="image-default" alt="<?php echo $item->title; ?>" title="#qitem-<?php echo $item->id; ?>" />
				<?php } ?>
			</div>
			<?php endforeach; ?>
		<?php endif; ?>
	</div>
	<div id="caption" class="nivo-html-caption">
		<?php if(count($items)) : ?>
			<?php foreach($items as $key=>$item) : ?> 
			<div id="qitem-<?php echo $item->id; ?>">
				<div class="itemTitle-itemIntroText" style="width: <?php echo $params->get('overlayWidth'); ?>px; height: <?php echo $params->get('overlayHeight'); ?>px;">
					<div class="itemTitle-itemIntroText-i">
						<!-- Item Title -->
						<?php 
							if($params->get('itemTitle') == 1) { ?>
								<?php if($params->get('itemTitleLink') == 1) { ?>
									<h3 class="moduleItemTitle"><a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h3>
								<?php } else { ?>
									<h3 class="moduleItemTitle"><span><?php echo $item->title; ?></span></h3>
								<?php } ?>
						<?php } ?>
						<!-- Introtext -->
						<?php 
							$item_text = strip_tags(preg_replace('/<img([^>]+)>/i',"",$item->introtext . $item->fulltext));
							if ($params->get('itemIntroText')) {
								if ($params->get('itemIntroTextWordLimit')) {
									echo $item_text = K2HelperUtilities::wordLimit($item->introtext . $item->fulltext, $params->get('itemIntroTextWordLimit'));
								} else {
									echo $item->introtext;
								}
							} ?>
						<!-- Read more -->
						<?php if($params->get('showReadmore') == 1) : ?>
							<a class="itemReadmore" href="<?php echo $item->link; ?>"><?php echo JText::_('K2_READ_MORE'); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		<?php endif; ?>
	</div>
</div>

<script type="text/javascript" charset="utf-8">
<!--
jQuery(document).ready(function() {
	jQuery('#ot-k2-slideshow').nivoSlider({
		'animSpeed':<?php echo $params->get('duration','500') ?>,
		'pauseTime':<?php echo $params->get('interval','5000') ?>,
		'effect':'random'
	});
});
-->
</script>