<?php
/**
 * @version		$Id: helper.php 0001 December 2011 16:31:12Z OmegaTheme $
 * @package		OT K2 Extensions
 * @author			OmegaTheme http://omegatheme.com
 * @copyright		Copyright (c) 2011 OmegaTheme.
 * @license			http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @subpackage 	OT K2 Slideshow
 */

//No direct access
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');

class modOtK2SlideshowHelper {

	function getItems(&$params, $format = 'html') {

		jimport('joomla.filesystem.file');
		$mainframe = &JFactory::getApplication();
		$limit = $params->get('itemCount', 5);
		$cid = $params->get('category_id', NULL);
		$ordering = $params->get('itemsOrdering','');
		$componentParams = &JComponentHelper::getParams('com_k2');
		$limitstart = JRequest::getInt('limitstart');

		$user = &JFactory::getUser();
		$aid = $user->get('aid');
		$db = &JFactory::getDBO();

		$jnow = &JFactory::getDate();
		$now = $jnow->toMySQL();
		$nullDate = $db->getNullDate();

		if($params->get('source')=='specific'){
			
			$value = $params->get('items');
			$current = array();
			if(is_string($value) && !empty($value))
			$current[]=$value;
			if(is_array($value))
			$current=$value;

			$items = array();
			foreach($current as $id){

				$query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams 
				FROM #__k2_items as i 
				LEFT JOIN #__k2_categories c ON c.id = i.catid 
				WHERE i.published = 1 ";
				if(K2_JVERSION=='16'){
					$query .= " AND i.access IN(".implode(',', $user->authorisedLevels()).") ";
				}
				else {
					$query .=" AND i.access<={$aid} ";
				}
				$query .= " AND i.trash = 0 AND c.published = 1 ";
				if(K2_JVERSION=='16'){
					$query .= " AND c.access IN(".implode(',', $user->authorisedLevels()).") ";
				}
				else {
					$query .=" AND c.access<={$aid} ";
				}
				$query .= " AND c.trash = 0 
				AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." ) 
				AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." ) 
				AND i.id={$id}";
				if(K2_JVERSION=='16'){
					if($mainframe->getLanguageFilter()) {
						$languageTag = JFactory::getLanguage()->getTag();
						$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
					}
				}
				$db->setQuery($query);
				$item = $db->loadObject();
				if($item)
				$items[]=$item;

			}
		}else {
			$query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";

			if ($ordering == 'best')
			$query .= ", (r.rating_sum/r.rating_count) AS rating";

			if ($ordering == 'comments')
			$query .= ", COUNT(comments.id) AS numOfComments";

			$query .= " FROM #__k2_items as i LEFT JOIN #__k2_categories c ON c.id = i.catid";

			if ($ordering == 'best')
			$query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";

			if ($ordering == 'comments')
			$query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";
			if(K2_JVERSION=='16'){
				$query .= " WHERE i.published = 1 AND i.trash = 0 AND c.published = 1 AND c.trash = 0";
			}
			else {
				$query .= " WHERE i.published = 1 AND i.trash = 0 AND c.published = 1 AND c.access <= {$aid} AND c.trash = 0";
			}
			$query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
			$query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";


			if ($params->get('catfilter')) {
				if (!is_null($cid)) {
					if (is_array($cid)) {
						if ($params->get('getChildren')) {
							require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'itemlist.php');
							$categories = K2ModelItemlist::getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid IN ({$sql})";

						} else {
							JArrayHelper::toInteger($cid);
							$query .= " AND i.catid IN(".implode(',', $cid).")";
						}

					} else {
						if ($params->get('getChildren')) {
							require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'itemlist.php');
							$categories = K2ModelItemlist::getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid IN ({$sql})";
						} else {
							$query .= " AND i.catid=".(int)$cid;
						}

					}
				}
			}

			if ($params->get('FeaturedItems') == '0')
			$query .= " AND i.featured != 1";

			if ($params->get('FeaturedItems') == '2')
			$query .= " AND i.featured = 1";
			
			if ($ordering == 'comments')
			$query .= " AND comments.published = 1";

			switch ($ordering) {

				case 'date':
					$orderby = 'i.created ASC';
					break;

				case 'rdate':
					$orderby = 'i.created DESC';
					break;

				case 'alpha':
					$orderby = 'i.title';
					break;

				case 'ralpha':
					$orderby = 'i.title DESC';
					break;

				case 'order':
					if ($params->get('FeaturedItems') == '2')
					$orderby = 'i.featured_ordering';
					else
					$orderby = 'i.ordering';
					break;

				case 'rorder':
					if ($params->get('FeaturedItems') == '2')
					$orderby = 'i.featured_ordering DESC';
					else
					$orderby = 'i.ordering DESC';
					break;

				case 'hits':
					if ($params->get('popularityRange')){
						$datenow = &JFactory::getDate();
						$date = $datenow->toMySQL();
						$query.=" AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
					}
					$orderby = 'i.hits DESC';
					break;

				case 'rand':
					$orderby = 'RAND()';
					break;

				case 'best':
					$orderby = 'rating DESC';
					break;

				case 'comments':
					if ($params->get('popularityRange')){
						$datenow = &JFactory::getDate();
						$date = $datenow->toMySQL();
						$query.=" AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
					}
					$query.=" GROUP BY i.id ";
					$orderby = 'numOfComments DESC';
					break;
					
				case 'modified':
					$orderby = 'i.modified DESC';
					break;

				default:
					$orderby = 'i.id DESC';
					break;
			}

			$query .= " ORDER BY ".$orderby;
			
			$db->setQuery($query, 0, $limit);
			$items = $db->loadObjectList();
			//return $items;
		}

		require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'item.php');
		$model = new K2ModelItem;

		if (count($items)) {
			foreach ($items as $item) {
				
				//Clean title
				$item->title = JFilterOutput::ampReplace($item->title);
				
				//Read more link
				$item->link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($item->id.':'.urlencode($item->alias), $item->catid.':'.urlencode($item->categoryalias))));
				
				// Introtext
				if ($params->get('itemIntroText')) {
					// Word limit
					if ($params->get('itemIntroTextWordLimit')) {
						$item->text .= @K2HelperUtilities::wordLimit($textonly, $params->get('itemIntroTextWordLimit'));
					} else {
						$item->text .= $item->introtext;
					}
				}
				
				//Clean the plugin tags
				$item->introtext = preg_replace("#{(.*?)}(.*?){/(.*?)}#s", '', $item->introtext);
				
				$rows[] = $item;
			}
			return $rows;
		}
	}
}
