/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.OutputStream;
import java.util.regex.Pattern;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.exception.JUploadInterrupted;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.UploadFileData;

public abstract class DefaultFileUploadThread
extends Thread
implements FileUploadThread {
    public static final long TIME_BEFORE_CHECKING_NEXT_PACKET = 100L;
    UploadFileData[] filesToUpload = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    protected UploadPolicy uploadPolicy = null;
    private long maxChunkSize;
    protected String responseMsg = "";
    protected String responseBody = "";

    public DefaultFileUploadThread(String threadName, UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) {
        super(threadName);
        this.uploadPolicy = uploadPolicy;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        this.uploadPolicy.displayDebug("DefaultFileUploadThread created", 30);
    }

    abstract long getAdditionnalBytesForUpload(int var1) throws JUploadIOException;

    abstract void beforeRequest() throws JUploadException;

    abstract void startRequest(long var1, boolean var3, int var4, boolean var5) throws JUploadException;

    abstract int finishRequest() throws JUploadException;

    abstract void interruptionReceived();

    abstract void beforeFile(int var1) throws JUploadException;

    abstract void afterFile(int var1) throws JUploadException;

    abstract void cleanRequest() throws JUploadException;

    abstract void cleanAll() throws JUploadException;

    abstract OutputStream getOutputStream() throws JUploadException;

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getResponseMsg() {
        return this.responseMsg;
    }

    void setResponseBody(String body) {
        this.responseBody = this.normalizeCRLF(body);
    }

    void setResponseMsg(String msg) {
        this.responseMsg = this.normalizeCRLF(msg);
    }

    public final void run() {
        this.uploadPolicy.displayDebug("Start of the FileUploadThread", 5);
        try {
            while (!this.fileUploadManagerThread.isUploadFinished()) {
                this.filesToUpload = this.fileUploadManagerThread.getNextPacket();
                if (this.filesToUpload != null) {
                    this.uploadPolicy.displayDebug("Before do upload", 5);
                    this.doUpload();
                    this.uploadPolicy.displayDebug("After do upload", 5);
                    continue;
                }
                try {
                    DefaultFileUploadThread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (JUploadException e) {
            this.fileUploadManagerThread.setUploadException(e);
        }
        catch (JUploadInterrupted e) {
            this.uploadPolicy.displayInfo("Upload stopped by the user");
            this.uploadPolicy.displayDebug(e.getMessage(), 30);
        }
        this.uploadPolicy.displayDebug("End of the FileUploadThread", 5);
    }

    private final void doUpload() throws JUploadException, JUploadInterrupted {
        boolean bChunkEnabled = false;
        long totalContentLength = 0L;
        long totalFileLength = 0L;
        this.fileUploadManagerThread.setUploadStatus(0, 2);
        this.beforeRequest();
        for (int i = 0; i < this.filesToUpload.length; ++i) {
            totalContentLength += this.filesToUpload[i].getUploadLength();
            totalContentLength += this.getAdditionnalBytesForUpload(i);
            totalFileLength += this.filesToUpload[i].getUploadLength();
            this.uploadPolicy.displayDebug("file " + (this.fileUploadManagerThread.getNbUploadedFiles() + i) + ": content=" + this.filesToUpload[i].getUploadLength() + " bytes, getAdditionnalBytesForUpload=" + this.getAdditionnalBytesForUpload(i) + " bytes", 50);
        }
        if (totalFileLength >= this.maxChunkSize) {
            if (this.filesToUpload.length > 1) {
                this.fileUploadManagerThread.setUploadException(new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should be 1 (doUpload)"));
            }
            bChunkEnabled = true;
        }
        if (bChunkEnabled) {
            this.doChunkedUpload(totalContentLength, totalFileLength);
        } else {
            this.doNonChunkedUpload(totalContentLength, totalFileLength);
        }
        this.fileUploadManagerThread.currentRequestIsFinished(this.filesToUpload);
        this.fileUploadManagerThread.setUploadStatus(this.filesToUpload.length, 5);
    }

    private final void doChunkedUpload(long totalContentLength, long totalFileLength) throws JUploadException, JUploadInterrupted {
        boolean bLastChunk = false;
        int chunkPart = 0;
        long contentLength = 0L;
        long thisChunkSize = 0L;
        if (this.filesToUpload.length > 1) {
            throw new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should not be more than 1 (doUpload)");
        }
        try {
            try {
                while (!bLastChunk && this.fileUploadManagerThread.getUploadException() == null) {
                    bLastChunk = contentLength > this.filesToUpload[0].getRemainingLength();
                    thisChunkSize = bLastChunk ? this.filesToUpload[0].getRemainingLength() : this.maxChunkSize;
                    contentLength = thisChunkSize + this.getAdditionnalBytesForUpload(0);
                    this.fileUploadManagerThread.setUploadStatus(0, 2);
                    this.startRequest(contentLength, true, ++chunkPart, bLastChunk);
                    this.beforeFile(0);
                    this.filesToUpload[0].uploadFile(this.getOutputStream(), thisChunkSize);
                    if (bLastChunk && this.filesToUpload[0].getRemainingLength() > 0L) {
                        throw new JUploadExceptionUploadFailed("Files has not be entirely uploaded. The remaining size is " + this.filesToUpload[0].getRemainingLength() + " bytes. File size was: " + this.filesToUpload[0].getUploadLength() + " bytes.");
                    }
                    this.afterFile(0);
                    int status = this.finishRequest();
                    if (bLastChunk) {
                        this.fileUploadManagerThread.setUploadStatus(0, 4);
                    } else {
                        this.fileUploadManagerThread.setUploadStatus(0, 3);
                    }
                    this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
                    this.cleanRequest();
                }
                this.fileUploadManagerThread.anotherFileHasBeenSent(this.filesToUpload[0]);
            }
            catch (JUploadInterrupted e) {
                this.interruptionReceived();
                throw e;
            }
            Object var13_9 = null;
            this.filesToUpload[0].afterUpload();
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            this.filesToUpload[0].afterUpload();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doNonChunkedUpload(long totalContentLength, long totalFileLength) throws JUploadException, JUploadInterrupted {
        this.startRequest(totalContentLength, false, 0, true);
        for (int i = 0; i < this.filesToUpload.length; ++i) {
            Object var7_4;
            this.fileUploadManagerThread.setUploadStatus(i, 2);
            try {
                this.beforeFile(i);
                this.filesToUpload[i].uploadFile(this.getOutputStream(), this.filesToUpload[i].getUploadLength());
                var7_4 = null;
                this.filesToUpload[i].afterUpload();
            }
            catch (Throwable throwable) {
                var7_4 = null;
                this.filesToUpload[i].afterUpload();
                throw throwable;
            }
            this.afterFile(i);
            this.fileUploadManagerThread.anotherFileHasBeenSent(this.filesToUpload[i]);
        }
        this.fileUploadManagerThread.setUploadStatus(this.filesToUpload.length, 4);
        int status = this.finishRequest();
        this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
        this.cleanRequest();
    }

    public void close() {
        try {
            this.cleanAll();
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    public final String normalizeCRLF(String s) {
        Pattern p = Pattern.compile("\\r\\n|\\r|\\n", 8);
        String[] lines = p.split(s);
        StringBuffer sb = new StringBuffer(s.length() * 2);
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append("\r\n");
        }
        return sb.toString();
    }

    public final String quoteCRLF(String s) {
        return s.replaceAll("\r\n", "\\\\r\\\\n\n");
    }

    public void setFileUploadThreadManager(FileUploadManagerThread fileUploadManagerThread) throws JUploadException {
        if (this.fileUploadManagerThread != null) {
            throw new JUploadException("Can not override fileUploadManagerThread (in DefaultFileUpload.setFileUploadThreadManager()");
        }
        this.fileUploadManagerThread = fileUploadManagerThread;
    }
}

